<?php
/*
Plugin Name: Phone Verification Plugin (Appruver)
Description: A simple phone verification plugin using Appruver API.
Version: 2.4
Author: Appruver
*/

register_activation_hook( __FILE__, 'phone_verification_plugin_activation' );

function phone_verification_plugin_activation()
{
    // Шлях до вашого CSS файлу
    $css_file_path = plugin_dir_path(__FILE__) . 'phone-verification.css';

    $default_css = '';
    // Перевірка чи файл існує перед тим як читати його
    if (file_exists($css_file_path)) {
        $default_css .= file_get_contents($css_file_path);
    }

    $default_css .= ".appr-modal-verify-number { color: red; }  /* Styles for number in modal window */\n";
    $default_css .= ".appr-modal-text-before-timer { color: red; } /* Styles for text before timer in modal window */\n";
    $default_css .= ".appr-modal-timer-container { color: red; } /* Styles for timer in modal window */\n";

    if (!get_option('phone_verification_custom_css')) {
        add_option('phone_verification_custom_css', $default_css);
    }
}

function phone_verification_enqueue_scripts()
{
    wp_register_style('phone-verification', false);
    wp_enqueue_style('phone-verification');
    //wp_enqueue_style('phone-verification', plugin_dir_url(__FILE__) . 'phone-verification.css');
    wp_enqueue_script('phone-verification', plugin_dir_url(__FILE__) . 'phone-verification.js', array('jquery'), '1.0', true);

    // Тепер додайте inline CSS до зареєстрованого стилю
    $custom_css = get_option('phone_verification_custom_css');
    $custom_css = str_replace(array("\r\n", "\r", "\n", "<br />", "<br/>", "<br>"), "", $custom_css);
    if (!empty($custom_css)) {
        wp_add_inline_style('phone-verification', $custom_css);
    }

    $plugin_settings = [
        'phoneInputSelector' => get_option('phone_verification_phone_input_selectors', ''),
        'apiToken' => get_option('phone_verification_api_token', ''),
        'buttonTextBefore' => get_option('phone_verification_button_text_before', 'Verify'),
        'buttonTextAfter' => get_option('phone_verification_button_text_after', 'Verified'),
        'modalTitle' => get_option('phone_verification_modal_title', 'Phone Verification'),
        'modalText' => get_option('phone_verification_modal_text', 'Please enter the verification code sent to your phone:'),
        'modalTextBeforeTimer' => get_option('phone_verification_modal_text_before_timer', ''),
        'verifyButtonText' => get_option('phone_verification_verify_button_text', 'Verify'),
    ];

    wp_localize_script('phone-verification', 'pluginSettings', $plugin_settings);
    wp_localize_script('phone-verification', 'phoneVerification', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('phone-verification-nonce')
    ));
}

add_action('wp_enqueue_scripts', 'phone_verification_enqueue_scripts');

$server_ip = $_SERVER['SERVER_ADDR'];

function inject_server_ip()
{
    global $server_ip;
    echo '<script>window.serverIP = "' . $server_ip . '";</script>';
}

add_action('wp_head', 'inject_server_ip');

// Создание страницы настроек плагина
add_action('admin_menu', 'phone_verification_plugin_settings_page');

function phone_verification_plugin_settings_page()
{
    add_options_page(
        'Phone Verification Settings',
        'Phone Verification',
        'manage_options',
        'phone-verification-settings',
        'phone_verification_settings_page_callback'
    );
}

// Отображение страницы настроек плагина
function phone_verification_settings_page_callback()
{
    if (!current_user_can('manage_options')) {
        return;
    }

    // Сохранение настроек
    if (isset($_POST['save_phone_verification_settings'])) {
        update_option('phone_verification_phone_input_selectors', stripslashes(sanitize_text_field($_POST['phone_input_selectors'])));
        update_option('phone_verification_api_token', sanitize_text_field($_POST['api_token']));
        update_option('phone_verification_button_text_before', sanitize_text_field($_POST['button_text_before']));
        update_option('phone_verification_button_text_after', sanitize_text_field($_POST['button_text_after']));
        update_option('phone_verification_modal_title', sanitize_text_field($_POST['modal_title']));
        update_option('phone_verification_modal_text', sanitize_text_field($_POST['modal_text']));
        update_option('phone_verification_modal_text_before_timer', sanitize_text_field($_POST['modal_text_before_timer']));
        update_option('phone_verification_verify_button_text', sanitize_text_field($_POST['verify_button_text']));
        update_option('phone_verification_custom_css', nl2br($_POST['custom_css']));

    }

    // Получение настроек
    $phone_input_selectors = get_option('phone_verification_phone_input_selectors', '');
    $api_token = get_option('phone_verification_api_token', '');
    $button_text_before = get_option('phone_verification_button_text_before', 'Verify');
    $button_text_after = get_option('phone_verification_button_text_after', 'Verified');
    $modal_title = get_option('phone_verification_modal_title', 'Phone Verification');
    $modal_text = get_option('phone_verification_modal_text', 'Please enter the verification code sent to your phone:');
    $modal_text_before_timer = get_option('phone_verification_modal_text_before_timer', '');
    $verify_button_text = get_option('phone_verification_verify_button_text', 'Verify');
    $custom_css = get_option('phone_verification_custom_css', '');
    $custom_css = str_replace(array("<br />", "<br/>", "<br>"), "", $custom_css);


    // Форма настроек плагина
    echo '<div class="wrap">';
    echo '<h1>Phone Verification Settings</h1>';
    echo '<form method="post" action="">';
    echo '<table class="form-table">';
    echo '<tr valign="top">';
    echo '<th scope="row">Phone Input Selectors</th>';
    echo '<td><input type="text" name="phone_input_selectors" value="' . esc_attr($phone_input_selectors) . '" class="regular-text" placeholder="e.g. .ff-el-phone, #phone"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">API Token</th>';
    echo '<td><input type="text" name="api_token" value="' . esc_attr($api_token) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Button Text Before Verification</th>';
    echo '<td><input type="text" name="button_text_before" value="' . esc_attr($button_text_before) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Button Text After Verification</th>';
    echo '<td><input type="text" name="button_text_after" value="' . esc_attr($button_text_after) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Modal Title</th>';
    echo '<td><input type="text" name="modal_title" value="' . esc_attr($modal_title) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Modal Text</th>';
    echo '<td><input type="text" name="modal_text" value="' . esc_attr($modal_text) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Modal Text before timer</th>';
    echo '<td><input type="text" placeholder="Time for verification" name="modal_text_before_timer" value="' . esc_attr($modal_text_before_timer) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Verify Button Text</th>';
    echo '<td><input type="text" name="verify_button_text" value="' . esc_attr($verify_button_text) . '" class="regular-text"></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Custom CSS style</th>';
    echo '<td><textarea name="custom_css" id="custom_css" rows="15" cols="100">' . esc_attr($custom_css) . '</textarea></td>';
    echo '</tr>';
    echo '</table>';
    echo '<p class="submit"><input type="submit" name="save_phone_verification_settings" class="button button-primary" value="Save Changes"></p>';
    echo '</form>';
    echo '</div>';
}

// AJAX-обработчики
add_action('wp_ajax_send_verification_code', 'handle_send_verification_code');
add_action('wp_ajax_nopriv_send_verification_code', 'handle_send_verification_code');
add_action('wp_ajax_verify_code', 'handle_verify_code');
add_action('wp_ajax_nopriv_verify_code', 'handle_verify_code');


function handle_send_verification_code()
{
    check_ajax_referer('phone-verification-nonce');

    $phone = sanitize_text_field($_POST['phoneNumber']);
    $site_url = get_site_url(); // Отримуємо URL сайту
    $domain = parse_url($site_url, PHP_URL_HOST); // Отримуємо ім'я домена

    $response = wp_remote_get('https://control.appruver.app/api/code/send', array(
        'headers' => array(
            'Authorization' => 'Bearer ' . get_option('phone_verification_api_token', ''),
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Origin' => $site_url // Додаємо Origin до заголовків
        ),
        'body' => array(
            'phone' => $phone,
            'lang' => 'en',
            'domain_ws' => $domain
        )
    ));

    if (is_wp_error($response)) {
        wp_send_json_error($response->get_error_message());
    } else {
        wp_send_json_success(json_decode($response['body'], true));
    }

    wp_die();
}

function handle_verify_code()
{
    check_ajax_referer('phone-verification-nonce');

    $callId = sanitize_text_field($_POST['callId']);
    $typeVerification = sanitize_text_field($_POST['typeVerification']);
    $code = sanitize_text_field($_POST['code']);
    $site_url = get_site_url(); // Отримуємо URL сайту
    $domain = parse_url($site_url, PHP_URL_HOST); // Отримуємо ім'я домена

    $response = wp_remote_get('https://control.appruver.app/api/code/verification', array(
        'headers' => array(
            'Authorization' => 'Bearer ' . get_option('phone_verification_api_token', ''),
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Origin' => $site_url // Додаємо Origin до заголовків
        ),
        'body' => array(
            'call_id' => $callId,
            'type_verification' => $typeVerification,
            'code' => $code,
            'domain_ws' => $domain
        )
    ));

    if (is_wp_error($response)) {
        wp_send_json_error($response->get_error_message());
    } else {
        wp_send_json_success(json_decode($response['body'], true));
    }

    wp_die();
}


?>