let mainFunctionCalled = false;
let currentPhoneVerificationModal = null;
/*
(function(open, send) {

    XMLHttpRequest.prototype.open = function(method, url) {
        this._url = url; // Зберігаємо URL
        this._method = method; // Зберігаємо метод
        open.apply(this, arguments);
    };

    XMLHttpRequest.prototype.send = function(body) {
        this._body = body; // Зберігаємо тіло запиту
        console.log('URL:', this._url);
        console.log('Method:', this._method);
        console.log('Body:', this._body);

        // Перевіряємо URL, метод або тіло запиту і відміняємо, якщо потрібно
        if (this._body.includes('nf_ajax_submit')) {
            console.log('Запит може бути відмінено для NJ форми!');

            var field = document.querySelector('.appruver-nf-phone-input');
            if (field) {
                var fieldValue = field.value;
                if (fieldValue) {
                    console.log('Field:', field);
                    console.log('Field value:', fieldValue);
                    // Якщо поле знайдено і має значення, ви можете виконати додаткові дії тут.
                } else {
                    alert('Verfiy number!');
                    console.log('Запит відмінено для NJ форми!');
                    return; // Відміняємо запит
                }
            } else {
                console.log('Запит відмінено для NJ форми!');
                alert('Verfiy number!');
                return; // Відміняємо запит
            }

        }

        var xhr = this;
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                if (!mainFunctionCalled) {
                    console.log('AJAX request completed. Initializing mainFunction...');
                    mainFunction();
                    mainFunctionCalled = true;
                }
            }
        };

        send.apply(this, arguments);
    };

})(XMLHttpRequest.prototype.open, XMLHttpRequest.prototype.send);
* */
jQuery(document).ajaxComplete(function () {
    if (jQuery.active === 1 && !mainFunctionCalled) {
        console.log('AJAX request completed. Initializing mainFunction...');
        mainFunction();
        mainFunctionCalled = true;
    }
});

document.addEventListener('DOMContentLoaded', function () {
    console.log('DOMContentLoaded event fired. Initializing mainFunction...');
    mainFunction();
});


function mainFunction() {

    console.log('Plugin initialized');

    const apiToken = pluginSettings.apiToken ? pluginSettings.apiToken : '';
    const phoneInputSelector = pluginSettings.phoneInputSelector
        ? pluginSettings.phoneInputSelector
        : '';
    const buttonTextBefore = pluginSettings.buttonTextBefore
        ? pluginSettings.buttonTextBefore
        : 'Verify';
    const buttonTextAfter = pluginSettings.buttonTextAfter
        ? pluginSettings.buttonTextAfter
        : 'Verified';

    console.log('Phone Input Selector:', phoneInputSelector);

    if (!phoneInputSelector) {
        console.error(
            'Phone input selector is empty. Please check the plugin settings.'
        );
        return;
    }

    const forms = document.querySelectorAll('form');

    const phoneVerificationModal = new PhoneVerificationModal();
    phoneVerificationModal.init();


    currentPhoneVerificationModal = phoneVerificationModal;

    forms.forEach(function (form) {
        const phoneInput = form.querySelector(phoneInputSelector);

        if (!phoneInput) {
            return;
        }

        const existingButton = form.querySelector('.lets_verify');
        if (existingButton) {
            return;
        }

        const clonedPhoneInput = phoneInput.cloneNode(true);
        clonedPhoneInput.removeAttribute('name');

        const hiddenPhoneInput = document.createElement('input');
        hiddenPhoneInput.type = 'hidden';
        hiddenPhoneInput.name = phoneInput.getAttribute('name');

        if (form.querySelector('.nf-form-content')) {
            hiddenPhoneInput.className = 'appruver-nf-phone-input';
        }

        const inputContainer = document.createElement('div');
        inputContainer.className = 'phone-input-container';

        const verificationButton = document.createElement('button');
        verificationButton.innerHTML = buttonTextBefore;
        verificationButton.className = 'lets_verify';

        inputContainer.appendChild(clonedPhoneInput);
        inputContainer.appendChild(verificationButton);

        phoneInput.parentNode.insertBefore(inputContainer, phoneInput);
        phoneInput.parentNode.insertBefore(hiddenPhoneInput, phoneInput);
        phoneInput.parentNode.removeChild(phoneInput);

        verificationButton.addEventListener('click', function (event) {
            event.preventDefault();

            let phoneNumber = clonedPhoneInput.value;
            try {
                const itiInstance =
                    window.intlTelInputGlobals.getInstance(clonedPhoneInput);
                if (itiInstance) {
                    phoneNumber = itiInstance.getNumber();
                    if (!phoneNumber) {
                        console.log('Error: Number not returned from getNumber()');
                        showTooltip(clonedPhoneInput, 'Empty field');
                        return;
                    } else {
                        console.log('Phone Number:', phoneNumber);
                    }
                } else {
                    console.log(
                        'intlTelInput instance not found. Getting phone number from input value.'
                    );
                }
            } catch (e) {
            }

            phoneNumber = normalizePhoneNumber(phoneNumber);
            if (!phoneNumber) {
                console.error('Invalid phone number3');
                showTooltip(clonedPhoneInput, 'Empty field');
                return;
            }

            sendVerificationCode(phoneNumber)
                .then(function (response) {
                    if (response.error) {
                        console.error('Error from server:', response.error);

                        if (response.error === 'waiting_time') {
                            currentPhoneVerificationModal.timerDuration = response.waiting_time_in_sec - response.time_has_passed_in_sec;
                            currentPhoneVerificationModal.showWaitingTimeMessage(currentPhoneVerificationModal.timerDuration);
                            currentPhoneVerificationModal.show();
                        }else if(response.error === 'telegram_error'){
                            showTooltip(clonedPhoneInput, response.message);
                        }else {
                            showTooltip(clonedPhoneInput, 'Invalid phone number1');
                        }

                        return;
                    }

                    currentPhoneVerificationModal.setPhoneNumber(phoneNumber);

                    const callId = response.call_id;
                    if (response.waiting_time_in_sec) {
                        currentPhoneVerificationModal.timerDuration = response.waiting_time_in_sec;
                        currentPhoneVerificationModal.showWaitingTimeMessage(currentPhoneVerificationModal.timerDuration);
                        currentPhoneVerificationModal.show();
                    }

                    var verify_code = 0;
                    if (['readcode', 'listencode'].includes(response.type_verification)) {
                        verify_code = response.code;
                    }

                    currentPhoneVerificationModal.typeVerification = response.type_verification;
                    currentPhoneVerificationModal.showCodeInput();

                    currentPhoneVerificationModal.setVerificationCallback(function (
                        code
                    ) {
                        verifyCode(callId, currentPhoneVerificationModal.typeVerification, code)
                            .then(function (verificationResponse) {
                                if (verificationResponse.error) {
                                    // Проверка на наличие ошибки в ответе сервера
                                    console.error(
                                        'Error from server:',
                                        verificationResponse.error
                                    );
                                    currentPhoneVerificationModal.showErrorMessage(
                                        'Error verifying code'
                                    );
                                    return;
                                }
                                if (verificationResponse.success) {
                                    currentPhoneVerificationModal.hide();
                                    form.verified = true;
                                    clonedPhoneInput.setAttribute('readonly', true);
                                    hiddenPhoneInput.value = phoneNumber;
                                    verificationButton.innerHTML = buttonTextAfter;
                                    verificationButton.classList.add('verified');
                                    verificationButton.disabled = true;
                                } else {
                                    currentPhoneVerificationModal.showErrorMessage(
                                        'Invalid verification code'
                                    );
                                }
                            })
                            .catch(function (error) {
                                console.error('Send verification code request failed:', error);
                                if (error.error === 'waiting_time') {
                                    currentPhoneVerificationModal.showWaitingTimeMessage(error.waitingTime);
                                    currentPhoneVerificationModal.show();
                                } else {
                                    showTooltip(clonedPhoneInput, 'Error sending verification code2');
                                }
                            });
                    });

                    currentPhoneVerificationModal.closeBtn.addEventListener(
                        'click',
                        function () {
                            form.verified = false;
                            form.verificationStarted = false;
                            currentPhoneVerificationModal.hide();
                        }
                    );
                })
                .catch(function (error) {
                    console.error('Send verification code request failed:', error);
                    showTooltip(clonedPhoneInput, 'Error sending verification code2');
                });
        });
    });
}

function showTooltip(element, message) {

    let tooltip = document.querySelector('.error-tooltip');
    if (!tooltip) {
        tooltip = document.createElement('div');
        tooltip.className = 'error-tooltip';
        document.body.appendChild(tooltip);
    }

    tooltip.textContent = message;
    const rect = element.getBoundingClientRect();
    tooltip.style.left = rect.left + 'px';
    tooltip.style.top = rect.bottom + window.scrollY + 'px';
    tooltip.style.display = 'block';

    setTimeout(function () {
        tooltip.style.display = 'none';
    }, 3000);
}

function normalizePhoneNumber(phoneNumber) {
    return phoneNumber.replace(/\s/g, '').replace('+', '');
}

class PhoneVerificationModal {
    constructor() {
        this.modal = null;
        this.codeInputContainer = null;
        this.codeInput = null;
        this.errorMsg = null;
        this.verifyBtn = null;
        this.closeBtn = null;
        this.verificationCallback = null;
        this.timerContainer = null;
        this.timerInterval = null;
        this.typeVerification = 'sms';
        this.timerDuration = 60;
        this.textBeforeTimer = '<span class="appr-modal-text-before-timer">' + pluginSettings.modalTextBeforeTimer + '</span>';
    }

    init() {
        this.modal = document.createElement('div');
        this.modal.classList.add('phone-verification-modal');
        this.modal.innerHTML = `
        <div class="modal-content">
          <span class="close-btn">&times;</span>
          <h2>${pluginSettings.modalTitle}</h2>
          <p>${pluginSettings.modalText}</p>
          <span class="appr-modal-verify-number"></span>
          <div class="code-input-container" style="display: none;">
            <input type="text" class="code-input" maxlength="6" />
            <span class="error-message" style="display: none;"></span>
          </div>
          <div class="waiting-time-container" style="display: none;">
            <p class="waiting-time-message"></p>
          </div>
          <button class="verify-btn">${pluginSettings.verifyButtonText}</button>
          <div class="appr-modal-timer-container"></div>
        </div>
      `;

        this.codeInputContainer = this.modal.querySelector('.code-input-container');
        this.codeInput = this.modal.querySelector('.code-input');
        this.errorMsg = this.modal.querySelector('.error-message');
        this.verifyBtn = this.modal.querySelector('.verify-btn');
        this.closeBtn = this.modal.querySelector('.close-btn');
        this.timerContainer = this.modal.querySelector('.appr-modal-timer-container');
        this.waitingTimeContainer = this.modal.querySelector(
            '.waiting-time-container'
        );
        this.waitingTimeMessage = this.modal.querySelector('.waiting-time-message');

        this.verifyBtn.addEventListener('click', () => {
            if (this.verificationCallback) {
                this.verificationCallback(this.codeInput.value);
            }
        });

        this.closeBtn.addEventListener('click', () => {
            this.hide();
        });

        this.modal.addEventListener('transitionend', () => {
            const form = document.querySelector('form');
            if (form) {
                form.verificationStarted = false;
            }
        });

        document.body.appendChild(this.modal);
    }

    show() {
        console.log('Modal shown');
        this.modal.style.display = 'block';
        this.startTimer(this.timerDuration);
    }

    hide() {
        console.log('Modal hidden');
        this.modal.style.display = 'none';
        this.stopTimer();
    }

    setVerificationCallback(callback) {
        this.verificationCallback = callback;
    }

    setPhoneNumber(phoneNumber) {
        const verifyNumberElement = this.modal.querySelector('.appr-modal-verify-number');
        verifyNumberElement.textContent = phoneNumber;
    }

    showCodeInput() {
        this.codeInputContainer.style.display = 'block';
        this.waitingTimeContainer.style.display = 'none';
    }

    showWaitingTimeMessage(waitingTime) {
        this.waitingTimeMessage.textContent = `Please wait ${waitingTime} seconds and try again.`;
        this.waitingTimeContainer.style.display = 'none';
        this.codeInputContainer.style.display = 'block';
    }

    showErrorMessage(message) {
        this.errorMsg.textContent = message;
        this.errorMsg.style.display = 'block';
    }

    startTimer(remainingTime = this.timerDuration) {
        const updateTimer = () => {

            this.timerContainer.innerHTML = this.textBeforeTimer +' '+ remainingTime;

            if (remainingTime <= 0) {
               // this.stopTimer();
                this.hide();
                this.timerContainer.innerHTML = '';
                return;
            }

            remainingTime--;
        };

        this.timerInterval = setInterval(updateTimer, 1000);
        updateTimer();
    }

    stopTimer() {
        clearInterval(this.timerInterval);
    }

    destroy() {
        this.verifyBtn.removeEventListener('click', this.handleVerifyClick);
        this.closeBtn.removeEventListener('click', this.handleCloseClick);

        this.modal.remove();
    }
}

// Остальной код //

const apiToken = pluginSettings.apiToken ? pluginSettings.apiToken : '';

function sendVerificationCode(phoneNumber) {
    return new Promise(function (resolve, reject) {
        jQuery.ajax({
            url: phoneVerification.ajaxUrl,
            method: 'POST',
            data: {
                action: 'send_verification_code',
                phoneNumber: phoneNumber,
                _ajax_nonce: phoneVerification.nonce,
            },
            success: function (response) {
                if (response.success) {
                    console.log('Code has been sent:', response.data);
                    resolve(response.data);
                } else {
                    console.error('Error sending verification code:', response.data);
                    if (response.data.error === 'waiting_time') {
                        response.data.waitingTime =
                            response.data.waiting_time_in_sec -
                            response.data.time_has_passed_in_sec;
                    }
                    reject(response.data);
                }
            },
            error: function (error) {
                console.error('AJAX error:', error);
                reject('AJAX error');
            },
        });
    });
}

function verifyCode(callId, typeVerification, code) {
    return new Promise(function (resolve, reject) {
        jQuery.ajax({
            url: phoneVerification.ajaxUrl,
            method: 'POST',
            data: {
                action: 'verify_code',
                callId: callId,
                typeVerification: typeVerification,
                code: code,
                _ajax_nonce: phoneVerification.nonce,
            },
            success: function (response) {
                if (response.success) {
                    console.log('User is successfully verified:', response.data);
                    resolve(response.data);
                } else {
                    console.error('Error verifying code:', response.data);
                    reject(response.data);
                }
            },
            error: function (error) {
                console.error('AJAX error:', error);
                reject('AJAX error');
            },
        });
    });
}